// Copyright (c) 1998-2005 B2C2, Incorporated.  All Rights Reserved.
//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INCORPORATED.
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
//
// This file is proprietary source code of B2C2, Incorporated. and is released pursuant to and
// subject to the restrictions of the non-disclosure agreement and license contract entered
// into by the parties.
//
//
// B2FilterGraphException.cpp: implementation of the CB2FilterGraphException class.
//
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "B2FilterGraphException.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

///////////////////////////////////////////////////////////////////////////////
// Construction/Destruction
///////////////////////////////////////////////////////////////////////////////

CB2FilterGraphException::CB2FilterGraphException(DWORD dwError, LPCTSTR strError /*= NULL*/)
{
	m_dwError = dwError;
	if (   strError
		&& strlen( strError) > 0)
	{
		m_csError.Format( _T("%s failed (#%lX)!"), strError, m_dwError);;
	}
	else
	{
		m_csError.Format( _T("B2C2 Filter Graph error #%lX!"), m_dwError);;
	}
}

CB2FilterGraphException::~CB2FilterGraphException()
{
}

// virtual ////////////////////////////////////////////////////////////////////
BOOL CB2FilterGraphException::GetErrorMessage(LPTSTR lpszError, UINT nMaxError,
											  PUINT pnHelpContext /*= NULL*/)
{
	if (m_csError.IsEmpty())
	{
		return FALSE;
	}
	
	sprintf( lpszError, _T("%.*s"), nMaxError-1, m_csError);

	return TRUE;
}
